/*
 * Copyright (c) 2021. Henrik Bærbak Christensen, Aarhus University.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package cloud.cave.config;

import frds.broker.ClientRequestHandler;

/** Abstract factory for the client of SkyCave, creating
 * the delegates that are configurable.
 * 
 * @author Henrik Baerbak Christensen, Aarhus University.
 *
 */
public interface CaveClientFactory {

  /** Create the request handler for the client side.
   * 
   * @return a new client request handler
   */
  ClientRequestHandler createClientRequestHandler();

}
