/*
 * Copyright (c) 2021. Henrik Bærbak Christensen, Aarhus University.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package cloud.cave.domain;

/** The result of a logout operation.
 * 
 * @author Henrik Baerbak Christensen, Aarhus University
 *
 */
public enum LogoutResult {
  SUCCESS, // The logout was correct       
  PLAYER_NOT_IN_CAVE, // Attempted logout of player that is not in the cave
  SERVER_FAILURE // Some error happened on the server side, review logs
}
