package example;

import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.testcontainers.containers.GenericContainer;

import org.junit.*;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.*;

public class TestHelloSpark {

  public static final int SERVER_PORT = 4567;
  @ClassRule
  public static GenericContainer helloSpark =
          new GenericContainer("henrikbaerbak/hellospark")
                  .withExposedPorts(SERVER_PORT);
  private String serverRootUrl;

  @Before
  public void setup()
  {
    String address = helloSpark.getContainerIpAddress();
    Integer port = helloSpark.getMappedPort(SERVER_PORT);
    serverRootUrl = "http://" + address + ":" + port + "/hello/";
  }

  @Test
  public void shouldGETonPathHello() throws UnirestException {
    // Code below not quite correct, 
    HttpResponse<String> reply =
            Unirest.get(serverRootUrl + "Henrik").asString();
    System.out.println("** ROOT: " + reply.getBody().toString());
    assertThat(reply.getStatus(), is(200));
  }
}
