package ap.redis;

import com.google.gson.Gson;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.List;

/** Template code for an AP to develop the Redis backed
 * CaveStorageConnector.
 *
 * Very RAW Template code, with magic constants and other
 * stuff I do NOT want to see in production ready solution
 * code :)
 *
 *
 * @author Henrik Bærbak Christensen, Aarhus University
 */
public class RedisCaveConnector implements CaveStorage {
  private final Jedis jedis;
  private final Gson gson;

  public RedisCaveConnector(String address, int port) {
    JedisPool pool = new JedisPool(address, port);
    jedis = pool.getResource();
    gson = new Gson();
  }

  @Override
  public RoomRecord getRoom(String positionString) {
    String asJSON = jedis.get("room"+positionString);
    if (asJSON == null) return null;
    return gson.fromJson(asJSON, RoomRecord.class);
  }

  @Override
  public int addRoom(String positionString, RoomRecord roomRecord) {
    String asJSON = gson.toJson(roomRecord);
    jedis.set("room"+positionString, asJSON);
    return 200;
  }

  @Override
  public int updateRoom(String positionString, RoomRecord updatedRoom) {
    return 0;
  }

  @Override
  public List<Direction> getSetOfExitsFromRoom(String positionString) {
    return null;
  }

  @Override
  public PlayerRecord getPlayerByID(String playerID) {
    return null;
  }

  @Override
  public void updatePlayerRecord(PlayerRecord record) {

  }

  @Override
  public List<PlayerRecord> computeListOfPlayersAt(String positionString) {
    return null;
  }

  @Override
  public void addMessage(String positionInCave, MessageRecord messageRecord) {

  }

  @Override
  public int updateMessage(String positionInCave, String messageId, MessageRecord newMessageRecord) {
    return 0;
  }

  @Override
  public List<MessageRecord> getMessageList(String positionInCave, int startIndex, int pageSize) {
    return null;
  }
}
