/*
 * Copyright (C)  2019. Henrik Bærbak Christensen, baerbak.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package ap.redis;

/**
 * Record type / PODO representing the subscription for a player. This
 * encapsulates the basic data that is transferred from the SubscriptionService
 * for authenticating a player.
 * 
 * @author Henrik Baerbak Christensen, Aarhus University.
 * 
 */
public class SubscriptionRecord {

  private String playerName;
  private String playerID;
  private String groupName;
  private Region region;
  private SubscriptionResult errorCode;
  
  /**
   * Construct a subscription match result that failed validation.
   * 
   * @param errorCode
   *          the code of the error describing the failed subscription
   */
  public SubscriptionRecord(SubscriptionResult errorCode) {
    this.errorCode = errorCode;
  }
  
  /** Construct a valid subscription object.
   * 
   * @param playerID id of player
   * @param playerName name of player
   * @param groupName name of group
   * @param region region of player
   */
  public SubscriptionRecord(String playerID, String playerName, String groupName, Region region) {
    this.playerName = playerName;
    this.playerID = playerID;
    this.groupName = groupName;
    this.region = region;
    this.errorCode = SubscriptionResult.LOGIN_NAME_HAS_VALID_SUBSCRIPTION;
  }
  
  public String getPlayerName() {
    return playerName;
  }

  public String getPlayerID() {
    return playerID;
  }

  public Region getRegion() {
    return region;
  }

  public SubscriptionResult getErrorCode() {
    return errorCode;
  }

  @Override
  public String toString() {
    return "SubscriptionRecord [playerName=" + playerName + ", playerID="
        + playerID + ", groupName=" + groupName + ", region=" + region
        + ", errorCode=" + errorCode + "]";
  }

  public String getGroupName() {
    return groupName;
  }

}
