/*
 * Copyright (C)  2019. Henrik Bærbak Christensen, baerbak.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package ap.redis;

/**
 * The result of matching a (loginName,password) with the
 * credentials stored in the subscription service will be
 * one of the following values.
 * 
 * @author Henrik Baerbak Christensen, Aarhus University
 * 
 */
public enum SubscriptionResult {
  LOGIN_NAME_HAS_VALID_SUBSCRIPTION, // Both login name and password match the subscription
  LOGIN_NAME_OR_PASSWORD_IS_UNKNOWN, // The login name is not found in subscription service
}
