package ap.redis;

import org.junit.jupiter.api.*;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.is;

@Testcontainers
public class TestRedisAP {
  protected CaveStorage storage;

  @Container
  public GenericContainer redisContainer =
          new GenericContainer("redis:7.2.1-alpine")
                  .withExposedPorts(6379);

  @BeforeEach
  public void setUp() throws Exception {
    storage = new RedisCaveConnector(
            redisContainer.getHost(),
            redisContainer.getFirstMappedPort());
  }

  private String p000 = "(0,0,0)";
  private String p273 = "(2,7,3)";

  @Test
  public void shouldUpdateRoomTables() {
    RoomRecord room;

    // validate that rooms can be made
    int canAdd = storage.addRoom(p273,
            new RoomRecord("You are in a dark lecturing hall.", CaveStorage.WILL_CROWTHER_ID));
    assertThat(canAdd, is(200));

    room = storage.getRoom(p273);
    assertThat(room.getDescription(), is("You are in a dark lecturing hall."));
    assertThat(room.getCreatorId(), is(CaveStorage.WILL_CROWTHER_ID));

    // validate that existing rooms cannot be overridden
    canAdd = storage.addRoom(p273, new RoomRecord("This room must never be made", "some-id"));

    // TODO: Reenable
    // assertThat(canAdd, is(false));
  }

  // TODO: Reenable
  @Disabled
  @Test
  public void shouldHaveInitialFourRooms() {
    RoomRecord room = storage.getRoom(p000);
    assertThat(room.getDescription(), is("You are standing at the end of a road before a small brick building."));
  }
}
