package chemicalplant;

import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.*;

import static org.hamcrest.MatcherAssert.assertThat; 
import static org.hamcrest.Matchers.*;
import static org.mockito.Mockito.*;

/** Test chemical plant valve control using Mockito.
 
   This source code is from the book 
     "Flexible, Reliable Software, 2nd Edition:
       Using Patterns and Agile Development"
     First Edition published by CRC Press, 2010.
     Second Edition, available for download
       by permission.

   Author: 
     Henrik Bærbak Christensen 
     Department of Computer Science
     Aarhus University
   
   Please visit http://www.baerbak.com/ for further information.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
 
       http://www.apache.org/licenses/LICENSE-2.0
 
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

*/
public class TestTemperatureRegulation {
  private PlantMonitor plantMonitor;
  private TemperatureSensor temperatureSensor;
  private CoolingSystem coolingSystem;

  @BeforeEach
  public void setup() {
    temperatureSensor = mock(TemperatureSensor.class);
    coolingSystem = mock(CoolingSystem.class);
    plantMonitor = new StandardPlantMonitor(temperatureSensor, 
                                            coolingSystem);
  }

  @Test
  public void shouldTurnOnCoolingAbove67degrees() {
    // Given a temperature sensor which returns 67.2
    when(temperatureSensor.readTemperature()).thenReturn(67.2);
    // When the monitor needs to regulate the temperature
    plantMonitor.regulateTemperature();
    // Then cooling is commanded to turn on cooling
    verify(coolingSystem).turnCoolingOn();
  }

  @Test
  public void shouldTurnOffCoolingBelow62degrees() {
    // Given a temperature above 67 that has turned on cooling
    when(temperatureSensor.readTemperature()).thenReturn(67.2);
    plantMonitor.regulateTemperature();
    // When temperature drops below 62
    when(temperatureSensor.readTemperature()).thenReturn(61.9);
    plantMonitor.regulateTemperature();
    // Then cooling system is commanded to turn off
    verify(coolingSystem).turnCoolingOff();
  }
}
