/** Simple bank account class with examples of use.
 * Henrik Bærbak Christensen, 2022
 *
 * To run using the raw Java compiler: 
 *  javac Account.java
 *  java Account 
 */

public class Account {
  private int balance; // Simplifying by only storing whole DKR amounts

  // The constructor initializes the object
  public Account() {
    balance = 0;
  }

  public int balance() { return balance; }
  public void deposit(int amount) { balance += amount; }
  public void withdraw(int amount) { balance -= amount; }

  // The main method which is starting point for a Java program
  public static void main(String args[]) {
    // Create an account
    Account henriksAccount = new Account();
    System.out.println("Henrik's account balance is: "
                       + henriksAccount.balance());
    // Create another account
    Account bennyAccount = new Account();
    // Insert on Henriks account
    henriksAccount.deposit(100);
    // and withdraw
    henriksAccount.withdraw(25);
    System.out.println("Henrik's account balance is now: "
                       + henriksAccount.balance());
    // and of course Benny's account is not affected
    System.out.println("Benny's account balance is unaffected: "
                       + bennyAccount.balance());
    
  }
}
