/** Circle with private access
 * Henrik Bærbak Christensen, 2022
 */

public class Circle {
  // Using private so no outside object can change my instance variables
  // except through the 'set' methods, which allows the object to
  // keep the mathematical law, p = 2rPI in place.
  private double radius;
  private double perimeter; 
  
  public Circle(double radius) {
    this.radius = radius;
    adjustPerimeter();
  }

  public double getRadius() { return radius; }
  public double getPerimeter() { return perimeter; }

  // By being public, you can set the radius to a new value
  // but by encapsulating it in a method, we can maintain
  // the perimeter's coupling to the
  public void setRadius(double newValue) {
    radius = newValue;
    // ensure that the perimeter value reflects the new radius
    adjustPerimeter();
  }

  // By being private, only the object itself can call this method
  private void adjustPerimeter() {
    this.perimeter = 2 * radius * Math.PI;
  }

  // implementing a 'setPerimeter()' left as an exercise
  
  public static void main(String args[]) {
    Circle c1 = new Circle(2.0);
    System.out.println("A: Circle r=" + c1.getRadius()
                       + ", p=" + c1.getPerimeter());
    // Set radius to 3.0
    c1.setRadius(3.0);
    System.out.println("B: Circle r=" + c1.getRadius()
                       + ", p=" + c1.getPerimeter());
  }
}
