/** A Playing card */
package card;

public class Card {
  private Rank rank;
  private Suit suit;
  
  public Card(Rank rank, Suit suit) {
    this.rank = rank; this.suit = suit;
  }

  public Rank getRank() { return rank; }
  public Suit getSuit() { return suit; }
  
  public String toString() {
    // Simple version
    // return "(" + rank + ", " + suit + ")";
    
    // Bit more complex version, removing the "_" from numbers
    int value = rank.ordinal() + 1; // first enum value is 0
    if (value >= 2 && value <= 10) {
      return "(" + value + ", " + suit + ")";
    }
    return "(" + rank + ", " + suit + ")";
  }
}
