/** A deck of playing cards
 * Henrik Bærbak Christensen - 2022
 */

package deck;

import java.util.*;
import card.*;

public class Deck {
  private List<Card> theDeck;

  public Deck() {
    theDeck = new ArrayList<Card>();
    // Initialize by running through all suits and ranks
    for (Suit s : Suit.values()) {
      for (Rank r : Rank.values()) {
        theDeck.add(new Card(r, s));
      }
    }
  }

  public void shuffle() {
    // The easy way: the Collection library already has the algorithm!
    // Collections.shuffle(theDeck);

    // The 'I do it myself' way using Fisher-Yates shuffle algorithm
    Random r = new Random();
    // Start from the last element and swap one by one. We don't
    // need to run for the first element that's why i > 0
    for (int i = theDeck.size()-1; i > 0; i--) {
      
      // Pick a random index from 0 to i
      int j = r.nextInt(i+1);
      
      // Swap arr[i] with the element at random index
      Card temp = theDeck.get(i);
      theDeck.set(i, theDeck.get(j));
      theDeck.set(j, temp);
    }
  }

  public Card pickTopCard() {
    return theDeck.remove(0);
  }

  public int count(Rank rank) {
    // A classic iteration way to count
    int count = 0;
    for (Card c : theDeck) {
      if (c.getRank() == rank) { count++; }
    }
    return count;

    // A Java8 streaming API way of counting
    /*
    return theDeck
      .stream()
      .filter( c -> c.getRank() == rank )
      .sum();*/
  }

  public String toString() {
    // Exercise: rewrite this to use for-loops instead...
    return Arrays.toString(theDeck.toArray());
  }
}
