/** Main for Shape
 * Henrik Bærbak Christensen, 2022
 */

import java.awt.Point;
import java.util.*;

public class Main {
  public static void main(String args[]) {
    // Declare a shape and bind it to a rectangle
    Shape shape = new Rectangle(new Point(56, 88));
    shape.draw();
    shape.moveBy(10, 20); 
    shape.draw();

    // shape can of course also be assigned a circle
    shape = new Circle(new Point(88,56));
    shape.draw();
    shape.moveBy(10, 20); 
    shape.draw();

    // We can handle lists of Shapes
    List<Shape> theList = new ArrayList<>();
    theList.add(new Rectangle(new Point(1,1)));
    theList.add(new Circle(new Point(7,7)));
    theList.add(new Rectangle(new Point(9,9)));

    // and move them all by (3,3)
    for (Shape s : theList) {
      s.moveBy(3,3);
    }
    
    // Java 8 way: theList.forEach( s -> s.moveBy(3,3) );

    // and draw them all, as a real gfx editor would
    System.out.println("=== Drawing all shapes ===");
    for (Shape s : theList) {
      s.draw();
    }

    // Java 8 way: theList.forEach( s -> s.draw() );
  }
}
