import java.awt.Point;

/** Shape is a general superclass, in which we program
 * behaviour shared by ALL shapes, like being able to 
 * move by a value.
 * Shapes can also ALL be drawn, but this abstract
 * class does not know exactly how, so it must be
 * defined in its concrete subclasses.
 */
public abstract class Shape {
  protected Point position;

  public void moveBy(int dx, int dy) {
    position.translate(dx, dy);
  }
  
  public abstract void draw();
}
