// This is a naive implementation, but fine for practicing
// Java coding skills.

public class Time24Hour {
  private int hour; private int minute;
  public Time24Hour(int hour, int minute) {
    this.hour = hour; this.minute = minute;
  }
  public void addMinutes(int value) {
    // First iteration: handle adding
    minute += value;
    while (minute >= 60) { hour += 1; minute -= 60; }
    // Next iteration: handling subtracting 
    while (minute < 0) { hour -= 1; minute += 60; }
  }
  
  public String toString() {
    // Easier alternative, using library functions.
    // return String.format("%02d:%02d", hour, minute);

    // Hand made alternative
    // Need to prefix a 0 if the time is less than 10
    String minuteAsString = (minute < 10) ? "0"+minute : ""+minute;
    String hourAsString = (hour < 10) ? "0"+hour : ""+hour;
    return "" + hourAsString + ":" + minuteAsString;

  }
}
