// This is an algoritmically better (smaller, more general) implementation

public class Time24HourAlt {
  // Only store minutes and compute hour upon request
  private int minute;
  public Time24HourAlt(int hour, int minute) {
    this.minute = 60 * hour + minute;
  }
  public void addMinutes(int value) {
    this.minute += value;
  }
  
  public String toString() {
    int minute = computeMinute();
    int hour = computeHour();
    String minuteAsString = (minute < 10) ? "0"+minute : ""+minute;
    String hourAsString = (hour < 10) ? "0"+hour : ""+hour;
    return "" + hourAsString + ":" + minuteAsString;
  }

  private int computeHour() {
    return minute / 60; // will return remainder
  }
  private int computeMinute() {
    return minute % 60; // will return modulo
  }
}
