// Provide a buffer (integer queue of size 1) between a Producer and a
// Consumer. This variant is coded using the original wait/notifyAll
// primitives on each object introduced in Java. And corresponds to
// the Jenkov Tutorial 'Blocking Queues'. Java 1.5 and later comes
// with a default implementation of this kind of buffer.

class BufferJava14 implements Buffer {
  private boolean empty = true;
  private int item;

  public BufferJava14() {
    System.out.println("=== Using BufferJava14 ===");
    System.out.println();
  }

  // Wait until the buffer is free, then fill it.
  public synchronized void store(int item) throws InterruptedException {
    while(!empty) {
      // Wait to be notified of the buffer being empty.
      wait();
    }
    this.item = item;
    empty = false;
    notifyAll();
  }

  public synchronized int retrieve() throws InterruptedException {
    while(empty) {
      // Wait to be notified of an item becoming available.
      wait();
    }
    // Retrieve the item before we notify waiting threads.
    int item = this.item;
    empty = true;
    notifyAll();
    return item;
  }

}
