// Implement a producer storing integers in a shared buffer
class Producer extends BufferUser implements Runnable {
  public Producer(Buffer b){
    super(b);
  }
  
  // Run forever storing consecutive integers into the buffer.
  public void run(){
    int i = 0;
    Buffer buffer = getBuffer();

    try {
      while(true){
        // Store the next item into the empty buffer.
        buffer.store(i);
        i++;
        // Sleep briefly.
        delay(67);
      }
    } catch (InterruptedException e) {
      e.printStackTrace();
    }

  }
}
