import java.util.concurrent.*;

// Provide a buffer (integer queue of size 1) between a Producer and a
// Consumer. This variant is coded using the Java 1.5 concurrent
// collection library methods.

class BufferBlockingQueue implements Buffer {

  private BlockingQueue<Integer> buffer =
    new ArrayBlockingQueue<Integer>(1);

  public BufferBlockingQueue() {
    System.out.println("=== Using BufferBlockingQueue ===");
    System.out.println();
  }
  
  public int retrieve() throws InterruptedException {
    return buffer.take();
  }

  public void store(int item) throws InterruptedException {
    buffer.put(item);
  }
}

