import java.util.concurrent.locks.*;

// Provide a buffer (integer queue of size 1) between a Producer and a
// Consumer. This variant is coded using the Java 1.5 Locks and Conditions.

// Source: JavaDoc for Condition. 

class BufferJava15Lock implements Buffer {
  Lock lock = new ReentrantLock();
  Condition notEmpty = lock.newCondition();
  Condition notFull = lock.newCondition();

  public BufferJava15Lock() {
    System.out.println("=== Using BufferJava15Lock ===");
    System.out.println();
  }

  public synchronized void store(int item) throws InterruptedException {
    lock.lock();
    try {
      while (!empty) {
        notFull.await();
      }
      // Fill it.
      this.item = item;
      empty = false;
      // Signal to waiting threads that queue is not empty
      notEmpty.signal();
    } finally {
      lock.unlock();
    }
  }

  public int retrieve() throws InterruptedException {
    int returnvalue = -1;
    lock.lock();
    try {
      while (empty) {
        notEmpty.await();
      }
      // Retrieve the item before we notify waiting threads.
      returnvalue = item;
      empty = true;
      // Signal to waiting threads that queue is not full
      notFull.signal();
    } finally {
      lock.unlock();
    }
    return returnvalue;
  }

  // Whether there is an item in the buffer or not.
  private boolean empty = true;
  // The buffered item.
  private int item;
}
