// Implement a consumer reading integers from a shared buffer.
class Consumer extends BufferUser implements Runnable {
  
  public Consumer(Buffer b) {
    super(b);
  }
  
  // Run forever retrieving integers from the buffer.
  public void run() {
    int i = 0;
    Buffer buffer = getBuffer();

    try {
      while(true){
        i = buffer.retrieve();
        System.out.print(i+" ");
        System.out.flush();
        // Sleep briefly.
        delay(80);
      }
    } catch (InterruptedException e) {
      e.printStackTrace();
    }
  }
}
