package webframeworks;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;

/**
 * A minimalistic demonstration of Unirest to fetch a web page.
 *

 */
public class ShowUniRest {
  public static void main(String args[]) throws UnirestException {
    HttpResponse<String> reply =
            Unirest.get("http://www.baerbak.com/contact.html")
      .asString();
    System.out.println("Reply status code: " + reply.getStatus()
                       + " " + reply.getStatusText());
    System.out.println("Content-Type: "
                       + reply.getHeaders().getFirst("Content-Type") );
    System.out.println("Body (First 500 chars):\n" +
                       reply.getBody().substring(0, 500));
  }
}

