/*
 * Copyright 2014 Henrik Baerbak Christensen, Aarhus University
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package cs.rsa.triangle;

/** The classic in all testing literature: the
 * triangle problem - determine the type of triangle.
 *
 * Here two implementations are given. My own, which
 * was made TDD and without looking into classic solutions,
 * and one from Paul C Jorgensen's book.
 * 
 * @author Henrik Baerbak Christensen, Aarhus University
 *
 */
public class TriangleProblem {

  /** Given the three sides of a triangle, a, b and c.,
   * determine its type: Equilateral, Isosceles, Scalene,
   * or NotATriangle
   * PreCondition: all sides are positive and larger than 0
   * @param a length of one side of triangle
   * @param b length of one side of triangle
   * @param c length of one side of triangle
   * @return
   */
  public static TriangleType determine(int a, int b, int c) {
    TriangleType t1, t2;
    t1 = HBCsTDDImplementation(a,b,c);
    t2 = JorgensenSecondImplementation(a,b,c);
    return t2; // or change to t2, depending on which you are testing...
  }

  /** Henrik Baerbak's implementation, using TDD principles. And without
      peeking into existing literature :) */
  public static TriangleType HBCsTDDImplementation(int a, int b, int c) {
     // Make a bubble sort of a,b,c so they are sorted
    // shortests to longest. 
    int shortest = a;
    int longer = b;
    int longest = c;
    int swap;
    // bubble sort with three items, 1 scan
    if ( longer > longest ) {
      swap = longer; longer = longest; longest = swap;
    }
    if ( shortest > longer ) {
      swap = shortest; shortest = longer; longer = swap;
    }
    // 2 scan
    if ( longer > longest ) {
      swap = longer; longer = longest; longest = swap;
    }
    // Test that it is indeed a triangle i.e. the sum of
    // the two shortest legs are equal or bigger than the
    // longest leg
    if ( shortest + longer <= longest ) return TriangleType.NotATriangle;

    // Next do the triangle tests
    if ( a == b && b == c ) return TriangleType.Equilateral;
    if ( a == c || b == c || a == b ) 
      return TriangleType.Isosceles;
    return TriangleType.Scalene;
  }

  /** From Software Testing 4ed, by Paul C. Jorgensen, p. 22. Just
   converted to java and then run through my test cases. */
  public static TriangleType JorgensenSecondImplementation(int a, int b, int c) {
    boolean isATriangle;
    if ( a < b + c && b < a + c && c < a + b ) 
      isATriangle = true;
    else
      isATriangle = false;

    TriangleType type;
    if ( isATriangle ) 
      if ( a == b && b == c )
        type = TriangleType.Equilateral;
      else 
        if ( a != b && a != c && b != c )
          type = TriangleType.Scalene;
        else
          type = TriangleType.Isosceles;
    else
      type = TriangleType.NotATriangle;

    return type;
  }
  

}
