/*
 * Copyright 2014 Henrik Baerbak Christensen, Aarhus University
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package cs.rsa.triangle;

import org.junit.*; 
import static org.junit.Assert.*; 

/** JUnit test cases for the classic Triangle exercise.
 * Developed using TDD along with the implementation.
 * 
 * @author Henrik Baerbak Christensen, Aarhus University
 *
 */
public class TestTriangle {

  // Drive Fake-it in place on Equilateral
  @Test
  public void shouldDetectEquilateral() {
    assertEquals( TriangleType.Equilateral, TriangleProblem.determine(4,4,4));
  }

  // Drive the test (a==b==c) in place, fake-it on Isosceles
  @Test
  public void shouldDetectIsoscelesBC() {
    assertEquals( TriangleType.Isosceles, TriangleProblem.determine(3,4,4));
  }

  // Drive the test ( a == c || b == c ) in place,
  @Test
  public void shouldDetectIsoscelesAC() {
    assertEquals( TriangleType.Isosceles, TriangleProblem.determine(4,3,4));
  }

  // Drive the fall-through on Scalene in place
  @Test
  public void shouldDetectScalene() {
    assertEquals( TriangleType.Scalene, TriangleProblem.determine(4,3,2));
  }

  // Triangulate the complete algorithm for Isosceles in place
  @Test
  public void shouldDetectIsoscelesAB() {
    assertEquals( TriangleType.Isosceles, TriangleProblem.determine(4,4,3));
  }

  // Drive NotATriangle in place, first (a+b <= c) in place
  @Test
  public void shouldDetectNotTriangleWithLongC() {
    assertEquals( TriangleType.NotATriangle, 
                  TriangleProblem.determine(4,4,9));
  }
  // Triangulate the sorting of edges into place, step one
  // in bubble sort, swap b,c in case b > c
  @Test
  public void shouldDetectNotTriangleWithLongB() {
    assertEquals( TriangleType.NotATriangle, 
                  TriangleProblem.determine(4,9,4));
  }
  // Triangulate last part of edge sorting in place,
  // a > b, and second scan
  @Test
  public void shouldDetectNotTriangleWithLongA() {
    assertEquals( TriangleType.NotATriangle, 
                  TriangleProblem.determine(9,4,4));
  }

  // Reassurance test :) Try worst possible combination
  @Test
  public void shouldDetectNotTriangleWithAllInWrongDirection() {
    assertEquals( TriangleType.NotATriangle, 
                  TriangleProblem.determine(37,24,12));
  }

  // Done for the case where precondition of a,b,c are
  // all > 0 is upheld

  // Boundary case - the value where the triangle is 'flat'
  // and thus not a triangle
  @Test
  public void shouldDetectNotTriangleWhenDegenerate() {
    assertEquals( TriangleType.NotATriangle, 
                  TriangleProblem.determine(3,3,6));
  }
  
}
